"use strict";const perf=require("./vs/base/common/performance");perf.mark("code/didStartMain");const path=require("path"),fs=require("fs"),os=require("os"),bootstrap=require("./bootstrap"),bootstrapNode=require("./bootstrap-node"),{getUserDataPath}=require("./vs/platform/environment/node/userDataPath"),{stripComments}=require("./vs/base/common/stripComments"),product=require("../product.json"),{app,protocol,crashReporter}=require("electron"),portable=bootstrapNode.configurePortable(product);bootstrap.enableASARSupport();const args=parseCLIArgs(),userDataPath=getUserDataPath(args);app.setPath("userData",userDataPath);const codeCachePath=getCodeCachePath(),argvConfig=configureCommandlineSwitchesSync(args);perf.mark("code/willStartCrashReporter"),(args["crash-reporter-directory"]||argvConfig["enable-crash-reporter"]&&!args["disable-crash-reporter"])&&configureCrashReporter(),perf.mark("code/didStartCrashReporter"),portable&&portable.isPortable&&app.setAppLogsPath(path.join(userDataPath,"logs")),protocol.registerSchemesAsPrivileged([{scheme:"vscode-webview",privileges:{standard:!0,secure:!0,supportFetchAPI:!0,corsEnabled:!0,allowServiceWorkers:!0}},{scheme:"vscode-file",privileges:{secure:!0,standard:!0,supportFetchAPI:!0,corsEnabled:!0}}]),registerListeners();let nlsConfigurationPromise;const metaDataFile=path.join(__dirname,"nls.metadata.json"),locale=getUserDefinedLocale(argvConfig);if(locale){const{getNLSConfiguration:e}=require("./vs/base/node/languagePacks");nlsConfigurationPromise=e(product.commit,userDataPath,metaDataFile,locale)}app.once("ready",function(){if(args.trace){const e=require("electron").contentTracing,r={categoryFilter:args["trace-category-filter"]||"*",traceOptions:args["trace-options"]||"record-until-full,enable-sampling"};e.startRecording(r).finally(()=>onReady())}else onReady()});function startup(e,r){r._languagePackSupport=!0,process.env.VSCODE_NLS_CONFIG=JSON.stringify(r),process.env.VSCODE_CODE_CACHE_PATH=e||"",perf.mark("code/willLoadMainBundle"),require("./bootstrap-amd").load("vs/code/electron-main/main",()=>{perf.mark("code/didLoadMainBundle")})}async function onReady(){perf.mark("code/mainAppReady");try{const[,e]=await Promise.all([mkdirpIgnoreError(codeCachePath),resolveNlsConfiguration()]);startup(codeCachePath,e)}catch(e){console.error(e)}}function configureCommandlineSwitchesSync(e){const r=["disable-hardware-acceleration","force-color-profile"];process.platform==="linux"&&r.push("force-renderer-accessibility");const t=["enable-proposed-api","log-level"],n=readArgvConfigSync();Object.keys(n).forEach(o=>{const a=n[o];if(r.indexOf(o)!==-1)o==="force-color-profile"?a&&app.commandLine.appendSwitch(o,a):(a===!0||a==="true")&&(o==="disable-hardware-acceleration"?app.disableHardwareAcceleration():app.commandLine.appendSwitch(o));else if(t.indexOf(o)!==-1)switch(o){case"enable-proposed-api":Array.isArray(a)?a.forEach(c=>c&&typeof c=="string"&&process.argv.push("--enable-proposed-api",c)):console.error("Unexpected value for `enable-proposed-api` in argv.json. Expected array of extension ids.");break;case"log-level":typeof a=="string"&&process.argv.push("--log",a);break}}),app.commandLine.appendSwitch("disable-features","CalculateNativeWinOcclusion");const s=getJSFlags(e);return s&&app.commandLine.appendSwitch("js-flags",s),n}function readArgvConfigSync(){const e=getArgvConfigPath();let r;try{r=JSON.parse(stripComments(fs.readFileSync(e).toString()))}catch(t){t&&t.code==="ENOENT"?createDefaultArgvConfigSync(e):console.warn(`Unable to read argv.json configuration file in ${e}, falling back to defaults (${t})`)}return r||(r={}),r}function createDefaultArgvConfigSync(e){try{const r=path.dirname(e);fs.existsSync(r)||fs.mkdirSync(r);const t=["// This configuration file allows you to pass permanent command line arguments to VS Code.","// Only a subset of arguments is currently supported to reduce the likelihood of breaking","// the installation.","//","// PLEASE DO NOT CHANGE WITHOUT UNDERSTANDING THE IMPACT","//","// NOTE: Changing this file requires a restart of VS Code.","{","	// Use software rendering instead of hardware accelerated rendering.","	// This can help in cases where you see rendering issues in VS Code.",'	// "disable-hardware-acceleration": true',"}"];fs.writeFileSync(e,t.join(`
`))}catch(r){console.error(`Unable to create argv.json configuration file in ${e}, falling back to defaults (${r})`)}}function getArgvConfigPath(){const e=process.env.VSCODE_PORTABLE;if(e)return path.join(e,"argv.json");let r=product.dataFolderName;return process.env.VSCODE_DEV&&(r=`${r}-dev`),path.join(os.homedir(),r,"argv.json")}function configureCrashReporter(){let e=args["crash-reporter-directory"],r="";if(e){if(e=path.normalize(e),path.isAbsolute(e)||(console.error(`The path '${e}' specified for --crash-reporter-directory must be absolute.`),app.exit(1)),!fs.existsSync(e))try{fs.mkdirSync(e,{recursive:!0})}catch{console.error(`The path '${e}' specified for --crash-reporter-directory does not seem to exist or cannot be created.`),app.exit(1)}console.log(`Found --crash-reporter-directory argument. Setting crashDumps directory to be '${e}'`),app.setPath("crashDumps",e)}else{const o=product.appCenter;if(o){const a=process.platform==="win32",c=process.platform==="linux",d=process.platform==="darwin",i=argvConfig["crash-reporter-id"];if(/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(i)){if(a)switch(process.arch){case"ia32":r=o["win32-ia32"];break;case"x64":r=o["win32-x64"];break;case"arm64":r=o["win32-arm64"];break}else if(d)if(product.darwinUniversalAssetId)r=o["darwin-universal"];else switch(process.arch){case"x64":r=o.darwin;break;case"arm64":r=o["darwin-arm64"];break}else c&&(r=o["linux-x64"]);r=r.concat("&uid=",i,"&iid=",i,"&sid=",i);const l=process.argv,u=l.indexOf("--");u===-1?l.push("--crash-reporter-id",i):l.splice(u,0,"--crash-reporter-id",i)}}}const t=(product.crashReporter?product.crashReporter.productName:void 0)||product.nameShort,n=(product.crashReporter?product.crashReporter.companyName:void 0)||"Microsoft",s=!process.env.VSCODE_DEV&&r&&!e;crashReporter.start({companyName:n,productName:process.env.VSCODE_DEV?`${t} Dev`:t,submitURL:r,uploadToServer:s,compress:!0})}function getJSFlags(e){const r=[];return e["js-flags"]&&r.push(e["js-flags"]),e["max-memory"]&&!/max_old_space_size=(\d+)/g.exec(e["js-flags"])&&r.push(`--max_old_space_size=${e["max-memory"]}`),r.length>0?r.join(" "):null}function parseCLIArgs(){return require("minimist")(process.argv,{string:["user-data-dir","locale","js-flags","max-memory","crash-reporter-directory"]})}function registerListeners(){const e=[];global.macOpenFiles=e,app.on("open-file",function(n,s){e.push(s)});const r=[],t=function(n,s){n.preventDefault(),r.push(s)};app.on("will-finish-launching",function(){app.on("open-url",t)}),global.getOpenUrls=function(){return app.removeListener("open-url",t),r}}function getCodeCachePath(){if(process.argv.indexOf("--no-cached-data")>0||process.env.VSCODE_DEV)return;const e=product.commit;if(!!e)return path.join(userDataPath,"CachedData",e)}function mkdirp(e){return new Promise((r,t)=>{fs.mkdir(e,{recursive:!0},n=>n&&n.code!=="EEXIST"?t(n):r(e))})}async function mkdirpIgnoreError(e){if(typeof e=="string")try{return await mkdirp(e),e}catch{}}async function resolveNlsConfiguration(){let e=nlsConfigurationPromise?await nlsConfigurationPromise:void 0;if(!e){let r=app.getLocale();if(!r)e={locale:"en",availableLanguages:{}};else{r=r.toLowerCase();const{getNLSConfiguration:t}=require("./vs/base/node/languagePacks");e=await t(product.commit,userDataPath,metaDataFile,r),e||(e={locale:r,availableLanguages:{}})}}return e}function getUserDefinedLocale(e){const r=args.locale;return r?r.toLowerCase():e.locale&&typeof e.locale=="string"?e.locale.toLowerCase():void 0}

//# sourceMappingURL=https://ticino.blob.core.windows.net/sourcemaps/784b0177c56c607789f9638da7b6bf3230d47a8c/core/main.js.map
